% Nise, N.S. 
% Control Systems Engineering, 7th ed. 
% John Wiley & Sons, Hoboken, NJ, 07030
%
% Control Systems Engineering Toolbox Version 7.0 
% Copyright  2015 by John Wiley & Sons, Inc.

% TryIt 11.2
% Use MATLAB, the Control System Toolbox, and the 
% following statements to solve Skill-Assessment 
% Exercise 11.2.

'TryIt 11.2'
pos=20
Ts=0.2
z=(-log(pos/100))/(sqrt(pi^2+log(pos/100)^2))
Pm=atan(2*z/(sqrt(-2*z^2+sqrt(1+4*z^4))))*(180/pi)
Wbw=(4/(Ts*z))*sqrt((1-2*z^2)+sqrt(4*z^4-4*z^2+2))
K=1942000
G=zpk([],[0,-50,-120],K)
sisotool(G,1)


% When the SISO Design for SISO Design Task Window appears:
% 1. Right-click on the Bode plot area and select Grid.
% 2. Note the phase margin shown in the MATLAB Command Window.
% 3. Using the Bode phase plot, estimate the frequency at 
%    which the phase margin from Step 2 occurs.
% 4. On the SISO Design for SISO Design Task Window toolbar, 
%    click on the red zero.
% 5. Place the zero of the compensator by clicking on the 
%    gain plot at a frequency that is 1/10 that found in Step 3.
% 6. On the SISO Design for SISO Design Task Window toolbar, 
%    click on the red pole.
% 7. Place the pole of the compensator by clicking on the gain 
%    plot to the left of the compensator zero.
% 8. Grab the pole with the mouse and move it until the phase 
%    plot shows a P.M. equal to that found in Step 2.
% 9. Right-click in the Bode plot area and select 
%    Edit Compensator. . .
%10. Read the lag compensator in the Control and Estimation 
%    Tools Manager Window.